<?php
/**
 * API Test Script
 * Tests the authentication API endpoints
 */

echo "BioDynamic Farming Tracker - API Test\n";
echo "====================================\n\n";

$baseUrl = 'http://localhost/biodynamic_farming_tracker/backend';

// Test data
$testEmail = 'test' . time() . '@example.com';
$testPhone = '9' . rand(100000000, 999999999);
$testPassword = 'Test@123';
$testName = 'Test User';

echo "Test Configuration:\n";
echo "Base URL: $baseUrl\n";
echo "Test Email: $testEmail\n";
echo "Test Phone: $testPhone\n";
echo "Test Name: $testName\n\n";

// Helper function to make API calls
function callAPI($url, $method = 'GET', $data = null, $token = null) {
    $ch = curl_init();
    
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HEADER, false);
    
    $headers = ['Content-Type: application/json'];
    
    if ($token) {
        $headers[] = 'Authorization: Bearer ' . $token;
    }
    
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    
    if ($method === 'POST') {
        curl_setopt($ch, CURLOPT_POST, true);
        if ($data) {
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        }
    } elseif ($method === 'PUT') {
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'PUT');
        if ($data) {
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        }
    }
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    
    curl_close($ch);
    
    return [
        'code' => $httpCode,
        'body' => json_decode($response, true)
    ];
}

// Test 1: Register with Email
echo "Test 1: Register with Email\n";
echo "----------------------------\n";
$response = callAPI("$baseUrl/api/auth/register.php", 'POST', [
    'name' => $testName,
    'emailOrPhone' => $testEmail,
    'password' => $testPassword,
    'isEmail' => true
]);

echo "Status Code: " . $response['code'] . "\n";
echo "Response: " . json_encode($response['body'], JSON_PRETTY_PRINT) . "\n\n";

if ($response['body']['success']) {
    $otp = $response['body']['data']['otp'] ?? '123456';
    
    // Test 2: Verify OTP
    echo "Test 2: Verify OTP\n";
    echo "------------------\n";
    $response = callAPI("$baseUrl/api/auth/verify-otp.php", 'POST', [
        'emailOrPhone' => $testEmail,
        'otp' => $otp
    ]);
    
    echo "Status Code: " . $response['code'] . "\n";
    echo "Response: " . json_encode($response['body'], JSON_PRETTY_PRINT) . "\n\n";
    
    // Test 3: Login
    echo "Test 3: Login\n";
    echo "-------------\n";
    $response = callAPI("$baseUrl/api/auth/login.php", 'POST', [
        'emailOrPhone' => $testEmail,
        'password' => $testPassword,
        'isEmail' => true
    ]);
    
    echo "Status Code: " . $response['code'] . "\n";
    echo "Response: " . json_encode($response['body'], JSON_PRETTY_PRINT) . "\n\n";
    
    if ($response['body']['success']) {
        $accessToken = $response['body']['data']['access_token'];
        $refreshToken = $response['body']['data']['refresh_token'];
        
        // Test 4: Get Profile
        echo "Test 4: Get Profile\n";
        echo "-------------------\n";
        $response = callAPI("$baseUrl/api/user/profile.php", 'GET', null, $accessToken);
        
        echo "Status Code: " . $response['code'] . "\n";
        echo "Response: " . json_encode($response['body'], JSON_PRETTY_PRINT) . "\n\n";
        
        // Test 5: Update Profile
        echo "Test 5: Update Profile\n";
        echo "----------------------\n";
        $response = callAPI("$baseUrl/api/user/profile.php", 'PUT', [
            'farm_name' => 'Test Farm',
            'farm_location' => 'Test Location',
            'farm_size' => 5.5,
            'farm_size_unit' => 'acres'
        ], $accessToken);
        
        echo "Status Code: " . $response['code'] . "\n";
        echo "Response: " . json_encode($response['body'], JSON_PRETTY_PRINT) . "\n\n";
        
        // Test 6: Refresh Token
        echo "Test 6: Refresh Token\n";
        echo "---------------------\n";
        $response = callAPI("$baseUrl/api/auth/refresh-token.php", 'POST', [
            'refresh_token' => $refreshToken
        ]);
        
        echo "Status Code: " . $response['code'] . "\n";
        echo "Response: " . json_encode($response['body'], JSON_PRETTY_PRINT) . "\n\n";
        
        // Test 7: Logout
        echo "Test 7: Logout\n";
        echo "--------------\n";
        $response = callAPI("$baseUrl/api/auth/logout.php", 'POST', null, $accessToken);
        
        echo "Status Code: " . $response['code'] . "\n";
        echo "Response: " . json_encode($response['body'], JSON_PRETTY_PRINT) . "\n\n";
    }
}

// Test 8: Forgot Password
echo "Test 8: Forgot Password\n";
echo "-----------------------\n";
$response = callAPI("$baseUrl/api/auth/forgot-password.php", 'POST', [
    'emailOrPhone' => $testEmail,
    'isEmail' => true
]);

echo "Status Code: " . $response['code'] . "\n";
echo "Response: " . json_encode($response['body'], JSON_PRETTY_PRINT) . "\n\n";

if ($response['body']['success']) {
    $resetOtp = $response['body']['data']['otp'] ?? '123456';
    
    // Test 9: Reset Password
    echo "Test 9: Reset Password\n";
    echo "----------------------\n";
    $response = callAPI("$baseUrl/api/auth/reset-password.php", 'POST', [
        'emailOrPhone' => $testEmail,
        'otp' => $resetOtp,
        'newPassword' => 'NewTest@123'
    ]);
    
    echo "Status Code: " . $response['code'] . "\n";
    echo "Response: " . json_encode($response['body'], JSON_PRETTY_PRINT) . "\n\n";
}

echo "All tests completed!\n";

