<?php
/**
 * Database Setup Script
 * Run this script to create the database and tables
 */

require_once '../config/database.php';

echo "BioDynamic Farming Tracker - Database Setup\n";
echo "==========================================\n\n";

try {
    // Read the SQL file
    $sqlFile = __DIR__ . '/../database_schema.sql';
    
    if (!file_exists($sqlFile)) {
        die("Error: database_schema.sql file not found!\n");
    }
    
    $sql = file_get_contents($sqlFile);
    
    if ($sql === false) {
        die("Error: Could not read database_schema.sql file!\n");
    }
    
    echo "Connecting to database...\n";
    $db = getDBConnection();
    
    echo "Executing SQL statements...\n";
    
    // Split SQL into individual statements
    $statements = array_filter(
        array_map('trim', explode(';', $sql)),
        function($stmt) {
            return !empty($stmt) && !preg_match('/^--/', $stmt);
        }
    );
    
    $successCount = 0;
    $errorCount = 0;
    
    foreach ($statements as $statement) {
        try {
            $db->exec($statement);
            $successCount++;
        } catch (PDOException $e) {
            // Ignore "table already exists" errors
            if (strpos($e->getMessage(), 'already exists') === false) {
                echo "Warning: " . $e->getMessage() . "\n";
                $errorCount++;
            }
        }
    }
    
    echo "\n";
    echo "Database setup completed!\n";
    echo "Successful statements: $successCount\n";
    echo "Errors/Warnings: $errorCount\n";
    echo "\n";
    echo "Default admin credentials:\n";
    echo "Email: admin@biodynamic.com\n";
    echo "Password: admin123\n";
    echo "\n";
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
    exit(1);
}

