<?php
/**
 * API Router
 * 
 * Routes all API requests to appropriate endpoint files
 */

// Include configuration files
require_once __DIR__ . '/config/cors.php';
require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/config/database.php';
require_once __DIR__ . '/includes/helpers.php';
require_once __DIR__ . '/includes/jwt.php';

// Get the request URI
$request = isset($_GET['request']) ? $_GET['request'] : '';
$request = trim($request, '/');

// Get request method
$method = $_SERVER['REQUEST_METHOD'];

// Route the request
if (empty($request)) {
    sendResponse(true, 'BioDynamic Farming Tracker API ' . API_VERSION, [
        'version' => APP_VERSION,
        'api_version' => API_VERSION
    ]);
}

// Split the request into parts
$parts = explode('/', $request);

// Check if it's an API request
if ($parts[0] !== 'api') {
    sendError('Invalid API endpoint', 404);
}

// Remove 'api' from parts
array_shift($parts);

// Get the resource
$resource = isset($parts[0]) ? $parts[0] : '';

// Route to appropriate endpoint file
$endpointFile = __DIR__ . '/api/' . $resource;

// Check if it's a nested resource
if (count($parts) > 1) {
    // For nested resources like /api/auth/login
    $endpointFile .= '/' . $parts[1] . '.php';
} else {
    // For simple resources like /api/user
    $endpointFile .= '/index.php';
}

// Check if endpoint file exists
if (file_exists($endpointFile)) {
    require_once $endpointFile;
} else {
    sendError('Endpoint not found: ' . $request, 404);
}
?>

