<?php
/**
 * General Configuration
 */

// Timezone
date_default_timezone_set('Asia/Kolkata');

// JWT Secret Key (Change this to a random string in production)
define('JWT_SECRET_KEY', 'your-secret-key-change-this-in-production');
define('JWT_ALGORITHM', 'HS256');
define('JWT_EXPIRATION', 3600); // 1 hour
define('JWT_REFRESH_EXPIRATION', 2592000); // 30 days

// File Upload Settings
define('MAX_FILE_SIZE', 5242880); // 5MB in bytes
define('ALLOWED_IMAGE_TYPES', ['image/jpeg', 'image/png', 'image/jpg', 'image/webp']);
define('UPLOAD_PATH', __DIR__ . '/../uploads/');

// Pagination
define('DEFAULT_PAGE_SIZE', 20);
define('MAX_PAGE_SIZE', 100);

// OTP Settings
define('OTP_LENGTH', 6);
define('OTP_EXPIRATION', 600); // 10 minutes in seconds

// App Settings
define('APP_NAME', 'BioDynamic Farming Tracker');
define('APP_VERSION', '1.0.0');
define('API_VERSION', 'v1');

// Email Settings (Configure for production)
define('SMTP_HOST', 'smtp.gmail.com');
define('SMTP_PORT', 587);
define('SMTP_USERNAME', 'your-email@gmail.com');
define('SMTP_PASSWORD', 'your-password');
define('SMTP_FROM_EMAIL', 'noreply@biodynamicfarming.com');
define('SMTP_FROM_NAME', 'BioDynamic Farming Tracker');

// SMS Settings (Configure for production)
define('SMS_API_KEY', 'your-sms-api-key');
define('SMS_SENDER_ID', 'BDFARMING');

// Error Reporting
error_reporting(E_ALL);
ini_set('display_errors', 0); // Set to 1 for development, 0 for production
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/../logs/error.log');
?>

