<?php
require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../includes/helpers.php';
require_once __DIR__ . '/../../includes/jwt.php';

header('Content-Type: application/json');

// Require authentication
$userId = requireAuth();

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    // Get user profile
    try {
        $db = getDBConnection();

        $stmt = $db->prepare("
            SELECT id, name, email, phone, profile_photo, is_verified, is_admin, is_banned, created_at, last_login
            FROM users
            WHERE id = ?
        ");
        $stmt->execute([$userId]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if (!$user) {
            sendResponse(false, 'User not found', null, 404);
        }
        
        // Convert boolean fields
        $user['is_verified'] = (bool)$user['is_verified'];
        $user['is_admin'] = (bool)$user['is_admin'];
        $user['id'] = (int)$user['id'];
        
        sendResponse(true, 'Profile retrieved successfully', ['user' => $user]);
        
    } catch (PDOException $e) {
        error_log("Get profile error: " . $e->getMessage());
        sendResponse(false, 'Failed to retrieve profile', null, 500);
    }
    
} elseif ($_SERVER['REQUEST_METHOD'] === 'PUT') {
    // Update user profile
    try {
        $input = json_decode(file_get_contents('php://input'), true);
        
        $db = getDBConnection();
        
        // Build update query dynamically based on provided fields
        $updateFields = [];
        $params = [];
        
        if (isset($input['name']) && !empty($input['name'])) {
            $updateFields[] = "name = ?";
            $params[] = $input['name'];
        }

        if (isset($input['profile_photo'])) {
            $updateFields[] = "profile_photo = ?";
            $params[] = $input['profile_photo'];
        }
        
        if (empty($updateFields)) {
            sendResponse(false, 'No fields to update');
        }
        
        $updateFields[] = "updated_at = NOW()";
        $params[] = $userId;
        
        $sql = "UPDATE users SET " . implode(', ', $updateFields) . " WHERE id = ?";
        $stmt = $db->prepare($sql);
        $stmt->execute($params);
        
        // Get updated user
        $stmt = $db->prepare("
            SELECT id, name, email, phone, profile_photo, is_verified, is_admin, is_banned, created_at, last_login
            FROM users
            WHERE id = ?
        ");
        $stmt->execute([$userId]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);
        
        // Convert boolean fields
        $user['is_verified'] = (bool)$user['is_verified'];
        $user['is_admin'] = (bool)$user['is_admin'];
        $user['id'] = (int)$user['id'];
        
        // Log activity
        logActivity($userId, 'profile_updated', 'User profile updated');
        
        sendResponse(true, 'Profile updated successfully', ['user' => $user]);
        
    } catch (PDOException $e) {
        error_log("Update profile error: " . $e->getMessage());
        sendResponse(false, 'Failed to update profile', null, 500);
    }
    
} else {
    sendResponse(false, 'Method not allowed', null, 405);
}


