<?php
require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../includes/jwt.php';
require_once __DIR__ . '/../../includes/helpers.php';

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    sendErrorResponse('Method not allowed', 405);
}

// Get authorization header
$headers = getallheaders();
$authHeader = $headers['Authorization'] ?? '';

if (empty($authHeader) || !preg_match('/Bearer\s+(.*)$/i', $authHeader, $matches)) {
    sendErrorResponse('Authorization token required', 401);
}

$token = $matches[1];
$decoded = validateJWT($token);

if (!$decoded) {
    sendErrorResponse('Invalid or expired token', 401);
}

$userId = $decoded['user_id'];

// Get POST data
$data = json_decode(file_get_contents('php://input'), true);

if (!$data) {
    sendErrorResponse('Invalid JSON data', 400);
}

// Validate required fields
$customerName = $data['customer_name'] ?? null;

if (!$customerName) {
    sendErrorResponse('Customer name is required', 400);
}

try {
    $stmt = $db->prepare("
        INSERT INTO customers (
            user_id, customer_name, phone, email, address, notes
        ) VALUES (?, ?, ?, ?, ?, ?)
    ");
    
    $stmt->execute([
        $userId,
        $customerName,
        $data['phone'] ?? null,
        $data['email'] ?? null,
        $data['address'] ?? null,
        $data['notes'] ?? null
    ]);
    
    $customerId = $db->lastInsertId();
    
    // Get created customer
    $stmt = $db->prepare("
        SELECT 
            id, customer_name, phone, email, address, notes,
            created_at, updated_at
        FROM customers
        WHERE id = ?
    ");
    $stmt->execute([$customerId]);
    $customer = $stmt->fetch(PDO::FETCH_ASSOC);
    
    sendSuccessResponse('Customer created successfully', ['customer' => $customer], 201);
    
} catch (PDOException $e) {
    error_log("Database error: " . $e->getMessage());
    sendErrorResponse('Database error occurred', 500);
}


