<?php
/**
 * Get Harvests
 * GET /api/harvest/get-harvests.php
 */

require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../includes/helpers.php';
require_once __DIR__ . '/../../includes/jwt.php';

header('Content-Type: application/json');
$userId = requireAuth();

try {
    $db = getDBConnection();
    
    $cropId = isset($_GET['crop_id']) ? (int)$_GET['crop_id'] : null;
    $limit = isset($_GET['limit']) ? (int)$_GET['limit'] : 50;
    $offset = isset($_GET['offset']) ? (int)$_GET['offset'] : 0;
    
    $query = "
        SELECT 
            h.id,
            h.harvest_date,
            h.quantity,
            h.unit,
            h.quality_rating,
            h.notes,
            h.created_at,
            h.updated_at,
            c.id as crop_id,
            c.crop_name,
            c.crop_type,
            fs.id as farm_section_id,
            fs.section_name
        FROM harvests h
        LEFT JOIN crops c ON h.crop_id = c.id
        LEFT JOIN farm_sections fs ON c.farm_section_id = fs.id
        WHERE h.user_id = ?
    ";
    
    $params = [$userId];
    
    if ($cropId) {
        $query .= " AND h.crop_id = ?";
        $params[] = $cropId;
    }
    
    $query .= " ORDER BY h.harvest_date DESC LIMIT ? OFFSET ?";
    $params[] = $limit;
    $params[] = $offset;
    
    $stmt = $db->prepare($query);
    $stmt->execute($params);
    $harvests = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Get total count
    $countQuery = "SELECT COUNT(*) as total FROM harvests WHERE user_id = ?";
    $countParams = [$userId];
    
    if ($cropId) {
        $countQuery .= " AND crop_id = ?";
        $countParams[] = $cropId;
    }
    
    $countStmt = $db->prepare($countQuery);
    $countStmt->execute($countParams);
    $total = $countStmt->fetch(PDO::FETCH_ASSOC)['total'];
    
    sendResponse(true, 'Harvests retrieved successfully', [
        'harvests' => $harvests,
        'total' => (int)$total,
        'limit' => $limit,
        'offset' => $offset
    ]);
    
} catch (PDOException $e) {
    error_log('Database error: ' . $e->getMessage());
    sendResponse(false, 'Failed to retrieve harvests');
} catch (Exception $e) {
    error_log('Error: ' . $e->getMessage());
    sendResponse(false, 'An error occurred');
}


