<?php
require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../includes/jwt.php';
require_once __DIR__ . '/../../includes/helpers.php';

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

// Handle preflight request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Only allow GET requests
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    sendErrorResponse('Method not allowed', 405);
}

try {
    // Verify JWT token
    $userId = verifyJWT();
    
    // Get query parameters
    $type = isset($_GET['type']) ? trim($_GET['type']) : 'accepted'; // accepted, pending, sent
    
    // Get database connection
    $db = getDBConnection();
    
    if ($type === 'pending') {
        // Get pending requests received
        $stmt = $db->prepare("
            SELECT 
                f.id as request_id,
                u.id as user_id,
                u.name,
                u.email,
                f.created_at,
                'pending' as status
            FROM friends f
            INNER JOIN users u ON f.user_id = u.id
            WHERE f.friend_id = ? AND f.status = 'pending'
            ORDER BY f.created_at DESC
        ");
        $stmt->execute([$userId]);
        $friends = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
    } else if ($type === 'sent') {
        // Get pending requests sent
        $stmt = $db->prepare("
            SELECT 
                f.id as request_id,
                u.id as user_id,
                u.name,
                u.email,
                f.created_at,
                'pending' as status
            FROM friends f
            INNER JOIN users u ON f.friend_id = u.id
            WHERE f.user_id = ? AND f.status = 'pending'
            ORDER BY f.created_at DESC
        ");
        $stmt->execute([$userId]);
        $friends = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
    } else {
        // Get accepted friends
        $stmt = $db->prepare("
            SELECT 
                f.id as request_id,
                u.id as user_id,
                u.name,
                u.email,
                f.created_at,
                'accepted' as status
            FROM friends f
            INNER JOIN users u ON (
                CASE 
                    WHEN f.user_id = ? THEN f.friend_id = u.id
                    ELSE f.user_id = u.id
                END
            )
            WHERE (f.user_id = ? OR f.friend_id = ?) AND f.status = 'accepted'
            ORDER BY u.name ASC
        ");
        $stmt->execute([$userId, $userId, $userId]);
        $friends = $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
    
    $data = [
        'friends' => $friends,
        'total' => count($friends),
        'type' => $type,
    ];
    
    sendSuccessResponse('Friends retrieved successfully', $data);
    
} catch (Exception $e) {
    sendErrorResponse($e->getMessage(), 500);
}


