<?php
/**
 * Get Crops
 * GET /api/farm/get-crops.php
 */

require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../includes/helpers.php';
require_once __DIR__ . '/../../includes/jwt.php';

header('Content-Type: application/json');
$userId = requireAuth();

try {
    $db = getDBConnection();
    
    $sectionId = isset($_GET['section_id']) ? (int)$_GET['section_id'] : null;
    
    $query = "
        SELECT 
            c.id,
            c.crop_name,
            c.crop_type,
            c.variety,
            c.planting_date,
            c.expected_harvest_date,
            c.actual_harvest_date,
            c.status,
            c.notes,
            c.created_at,
            c.updated_at,
            fs.id as farm_section_id,
            fs.section_name
        FROM crops c
        LEFT JOIN farm_sections fs ON c.farm_section_id = fs.id
        WHERE c.user_id = ?
    ";
    
    $params = [$userId];
    
    if ($sectionId) {
        $query .= " AND c.farm_section_id = ?";
        $params[] = $sectionId;
    }
    
    $query .= " ORDER BY c.planting_date DESC";
    
    $stmt = $db->prepare($query);
    $stmt->execute($params);
    $crops = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    sendResponse(true, 'Crops retrieved successfully', ['crops' => $crops]);
    
} catch (PDOException $e) {
    error_log('Database error: ' . $e->getMessage());
    sendResponse(false, 'Failed to retrieve crops');
} catch (Exception $e) {
    error_log('Error: ' . $e->getMessage());
    sendResponse(false, 'An error occurred');
}


