<?php
require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../includes/jwt.php';
require_once __DIR__ . '/../../includes/helpers.php';

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

// Handle preflight request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Only allow POST requests
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    sendErrorResponse('Method not allowed', 405);
}

try {
    // Verify JWT token
    $userId = verifyJWT();
    
    // Get JSON input
    $input = json_decode(file_get_contents('php://input'), true);
    
    // Validate required fields
    if (!isset($input['post_id'])) {
        sendErrorResponse('Post ID is required', 400);
    }
    
    $postId = (int)$input['post_id'];
    
    // Get database connection
    $db = getDBConnection();
    
    // Check if post exists
    $stmt = $db->prepare("SELECT id FROM community_posts WHERE id = ?");
    $stmt->execute([$postId]);
    if (!$stmt->fetch()) {
        sendErrorResponse('Post not found', 404);
    }
    
    // Check if already liked
    $stmt = $db->prepare("SELECT id FROM community_likes WHERE post_id = ? AND user_id = ?");
    $stmt->execute([$postId, $userId]);
    $existingLike = $stmt->fetch();
    
    if ($existingLike) {
        // Unlike - remove the like
        $stmt = $db->prepare("DELETE FROM community_likes WHERE post_id = ? AND user_id = ?");
        $stmt->execute([$postId, $userId]);
        $isLiked = false;
        $message = 'Post unliked successfully';
    } else {
        // Like - add the like
        $stmt = $db->prepare("INSERT INTO community_likes (post_id, user_id) VALUES (?, ?)");
        $stmt->execute([$postId, $userId]);
        $isLiked = true;
        $message = 'Post liked successfully';
    }
    
    // Get updated likes count
    $stmt = $db->prepare("SELECT COUNT(*) as likes_count FROM community_likes WHERE post_id = ?");
    $stmt->execute([$postId]);
    $likesCount = $stmt->fetch(PDO::FETCH_ASSOC)['likes_count'];
    
    $data = [
        'is_liked' => $isLiked,
        'likes_count' => (int)$likesCount,
    ];
    
    sendSuccessResponse($message, $data);
    
} catch (Exception $e) {
    sendErrorResponse($e->getMessage(), 500);
}


