<?php
require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../includes/jwt.php';
require_once __DIR__ . '/../../includes/helpers.php';

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

// Handle preflight request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Only allow POST requests
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    sendErrorResponse('Method not allowed', 405);
}

try {
    // Verify JWT token
    $userId = verifyJWT();
    
    // Get JSON input
    $input = json_decode(file_get_contents('php://input'), true);
    
    // Validate required fields
    if (!isset($input['post_id'])) {
        sendErrorResponse('Post ID is required', 400);
    }
    
    $postId = (int)$input['post_id'];
    
    // Get database connection
    $db = getDBConnection();
    
    // Check if post exists
    $stmt = $db->prepare("SELECT id FROM community_posts WHERE id = ?");
    $stmt->execute([$postId]);
    if (!$stmt->fetch()) {
        sendErrorResponse('Post not found', 404);
    }
    
    // Check if already favorited
    $stmt = $db->prepare("SELECT id FROM community_favorites WHERE post_id = ? AND user_id = ?");
    $stmt->execute([$postId, $userId]);
    $existingFavorite = $stmt->fetch();
    
    if ($existingFavorite) {
        // Unfavorite - remove the favorite
        $stmt = $db->prepare("DELETE FROM community_favorites WHERE post_id = ? AND user_id = ?");
        $stmt->execute([$postId, $userId]);
        $isFavorited = false;
        $message = 'Post removed from favorites';
    } else {
        // Favorite - add the favorite
        $stmt = $db->prepare("INSERT INTO community_favorites (post_id, user_id) VALUES (?, ?)");
        $stmt->execute([$postId, $userId]);
        $isFavorited = true;
        $message = 'Post added to favorites';
    }
    
    $data = [
        'is_favorited' => $isFavorited,
    ];
    
    sendSuccessResponse($message, $data);
    
} catch (Exception $e) {
    sendErrorResponse($e->getMessage(), 500);
}


