<?php
require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../includes/jwt.php';
require_once __DIR__ . '/../../includes/helpers.php';

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

// Handle preflight request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Only allow GET requests
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    sendErrorResponse('Method not allowed', 405);
}

try {
    // Verify JWT token
    $userId = verifyJWT();
    
    // Get query parameters
    if (!isset($_GET['post_id'])) {
        sendErrorResponse('Post ID is required', 400);
    }
    
    $postId = (int)$_GET['post_id'];
    $limit = isset($_GET['limit']) ? (int)$_GET['limit'] : 50;
    $offset = isset($_GET['offset']) ? (int)$_GET['offset'] : 0;
    
    // Validate limit
    if ($limit < 1 || $limit > 100) {
        $limit = 50;
    }
    
    // Get database connection
    $db = getDBConnection();
    
    // Check if post exists
    $stmt = $db->prepare("SELECT id FROM community_posts WHERE id = ?");
    $stmt->execute([$postId]);
    if (!$stmt->fetch()) {
        sendErrorResponse('Post not found', 404);
    }
    
    // Get comments
    $stmt = $db->prepare("
        SELECT 
            c.id, c.comment, c.created_at, c.updated_at,
            u.id as user_id, u.name as user_name, u.email as user_email
        FROM community_comments c
        INNER JOIN users u ON c.user_id = u.id
        WHERE c.post_id = ?
        ORDER BY c.created_at DESC
        LIMIT ? OFFSET ?
    ");
    $stmt->execute([$postId, $limit, $offset]);
    $comments = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Get total count
    $stmt = $db->prepare("SELECT COUNT(*) as total FROM community_comments WHERE post_id = ?");
    $stmt->execute([$postId]);
    $total = $stmt->fetch(PDO::FETCH_ASSOC)['total'];
    
    $data = [
        'comments' => $comments,
        'total' => (int)$total,
        'limit' => $limit,
        'offset' => $offset,
    ];
    
    sendSuccessResponse('Comments retrieved successfully', $data);
    
} catch (Exception $e) {
    sendErrorResponse($e->getMessage(), 500);
}


