<?php
require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../includes/jwt.php';
require_once __DIR__ . '/../../includes/helpers.php';

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

// Handle preflight request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Only allow GET requests
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    sendErrorResponse('Method not allowed', 405);
}

try {
    // Verify JWT token
    $userId = verifyJWT();
    
    // Get database connection
    $db = getDBConnection();
    
    // Get all conversations (unique users with last message)
    $stmt = $db->prepare("
        SELECT 
            u.id as user_id,
            u.name,
            u.email,
            m.message as last_message,
            m.created_at as last_message_time,
            m.sender_id as last_sender_id,
            (SELECT COUNT(*) FROM chat_messages WHERE sender_id = u.id AND receiver_id = ? AND is_read = 0) as unread_count
        FROM users u
        INNER JOIN chat_messages m ON (
            (m.sender_id = u.id AND m.receiver_id = ?) OR 
            (m.sender_id = ? AND m.receiver_id = u.id)
        )
        WHERE u.id != ?
        AND m.id = (
            SELECT MAX(id) 
            FROM chat_messages 
            WHERE (sender_id = u.id AND receiver_id = ?) OR (sender_id = ? AND receiver_id = u.id)
        )
        ORDER BY m.created_at DESC
    ");
    $stmt->execute([$userId, $userId, $userId, $userId, $userId, $userId]);
    $conversations = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Convert unread_count to int
    foreach ($conversations as &$conversation) {
        $conversation['unread_count'] = (int)$conversation['unread_count'];
        $conversation['is_last_message_mine'] = $conversation['last_sender_id'] === $userId;
        unset($conversation['last_sender_id']);
    }
    
    $data = [
        'conversations' => $conversations,
        'total' => count($conversations),
    ];
    
    sendSuccessResponse('Conversations retrieved successfully', $data);
    
} catch (Exception $e) {
    sendErrorResponse($e->getMessage(), 500);
}


