<?php
require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../includes/helpers.php';
require_once __DIR__ . '/../../includes/jwt.php';

header('Content-Type: application/json');

// Only allow POST requests
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    sendResponse(false, 'Method not allowed', null, 405);
}

// Require authentication
$userId = requireAuth();

try {
    $db = getDBConnection();
    
    // Log activity
    logActivity($userId, 'user_logout', 'User logged out successfully');
    
    // In a production app, you might want to:
    // 1. Invalidate the refresh token in database
    // 2. Add the access token to a blacklist
    // 3. Clear any session data
    
    // Return success response
    sendResponse(true, 'Logout successful');
    
} catch (PDOException $e) {
    error_log("Logout error: " . $e->getMessage());
    sendResponse(false, 'Logout failed. Please try again later', null, 500);
}


